#ifndef ALIYUN_IOT_PLATFORM_THREADSYNC_H
#define ALIYUN_IOT_PLATFORM_THREADSYNC_H

#include "aliyun_iot_common_datatype.h"
#include "aliyun_iot_common_error.h"
#include "aliyun_iot_common_log.h"
#include "aliyun_iot_platform_memory.h"

#ifndef IOT_SDK_PLATFORM_UCOSIII

#include "ucos_ii.h"
#include "os_cfg.h"

#else

#include "os.h"
#include "os_cfg_app.h"

#endif

#ifndef IOT_SDK_PLATFORM_UCOSIII

typedef struct ALIYUN_IOT_SEM
{
	OS_EVENT *pOsEvent;
}ALIYUN_IOT_SEM_S;

#else

typedef struct ALIYUN_IOT_SEM
{
	OS_SEM *pOsSem;
}ALIYUN_IOT_SEM_S;

#endif
INT32 aliyun_iot_sem_init(ALIYUN_IOT_SEM_S *pSemIoT);

INT32 aliyun_iot_sem_destory(ALIYUN_IOT_SEM_S *pSemIoT);

INT32 aliyun_iot_sem_gettimeout(ALIYUN_IOT_SEM_S *pSemIoT, INT32 timeout_ms);

INT32 aliyun_iot_sem_post(ALIYUN_IOT_SEM_S *pSemIoT);

#endif

