#include "aliyun_iot_network_ssl.h"
#include "aliyun_iot_common_log.h"
#include "aliyun_iot_common_error.h"

int aliyun_iot_network_ssl_read(TLSDataParams *pTlsData, unsigned char *buffer, int len, int timeout_ms)
{
	int readLen = 0;
	int ret = -1;

	WRITE_IOT_DEBUG_LOG("qcom_SSL_read len=%d timer=%d ms", len, timeout_ms);

	IOT_NET_FD_ISSET_E result;
	ret = aliyun_iot_network_select(pTlsData->socketId, IOT_NET_TRANS_RECV, timeout_ms, &result);
	if(ret < 0)
	{
		INT32 err = aliyun_iot_get_errno();
		if(err == EINTR_IOT)
		{
			WRITE_IOT_DEBUG_LOG("continue");
		}
		else
		{
			WRITE_IOT_ERROR_LOG("mqtt ssl read(select) fail ret=%d", ret);
			return -1;
		}

	}
	else if (ret == 0)
	{
		WRITE_IOT_ERROR_LOG("mqtt ssl read(select) timeout");
		return -2;
	}
	else if (ret == 1)
	{
		WRITE_IOT_DEBUG_LOG("start to read packet");
	}

	while (readLen < len) 
	{
		ret = qcom_SSL_read(pTlsData->ssl, (unsigned char *)(buffer + readLen), (len - readLen));
		if (ret > 0) 
		{
			readLen += ret;
		} 
		else if (ret == 0) 
		{
			WRITE_IOT_ERROR_LOG("qcom_SSL_read read timeout");
			return -2; //eof
		} 
		else 
		{
			WRITE_IOT_ERROR_LOG("qcom_SSL_read error ret = -0x%x", ret);
			return -1; //Connnection error
		}
	}

	WRITE_IOT_DEBUG_LOG("qcom_SSL_read readlen=%d", readLen);
	return readLen;
}



int aliyun_iot_network_ssl_write(TLSDataParams *pTlsData, unsigned char *buffer, int len, int timeout_ms)
{
	size_t writtenLen = 0;
	int ret = 0;

	WRITE_IOT_DEBUG_LOG("qcom_SSL_write len=%d timer=%d", len, timeout_ms);
	while (writtenLen < len) 
	{
		ret = qcom_SSL_write(pTlsData->ssl, (unsigned char *)(buffer + writtenLen), (len - writtenLen));
		if (ret > 0) 
		{
			writtenLen += ret;
			continue;
		} 
		else if (ret == 0) 
		{
			WRITE_IOT_ERROR_LOG("qcom_SSL_write write timeout");
			return writtenLen;
		} 
		else 
		{
			WRITE_IOT_ERROR_LOG("qcom_SSL_write write fail ret= -0x%x", ret);
			return -1; //Connnection error
		}
	}
	WRITE_IOT_DEBUG_LOG("qcom_SSL_write write len=%d", writtenLen);
	return writtenLen;
}


void aliyun_iot_network_ssl_disconnect(TLSDataParams *pTlsData)
{
	if (pTlsData->ssl_ctx)
	{
        qcom_SSL_ctx_free(pTlsData->ssl_ctx);
        pTlsData->ssl_ctx = 0;
	}
	
	if (pTlsData->ssl)
	{
	    qcom_SSL_shutdown(pTlsData->ssl);
	    pTlsData->ssl = 0; 
	}

	if (pTlsData->socketId >= 0)
	{
		qcom_socket_close(pTlsData->socketId);
		pTlsData->socketId = -1;
	}

	if(pTlsData->ssl_cfg)
	{
		aliyun_iot_memory_free(pTlsData->ssl_cfg);
		pTlsData->ssl_cfg = NULL;
	}
}

unsigned int iot_inet_addr(char *str)
{
    unsigned int ipaddr;
    unsigned int data[4];
    unsigned int ret;

    ret = sscanf(str, "%3d.%3d.%3d.%3d", data, data + 1, data + 2, data + 3);
    if (ret < 0) 
	{
        return 0;
    } 
	else 
	{
        ipaddr = data[0] << 24 | data[1] << 16 | data[2] << 8 | data[3];
    }
    return ipaddr;
}

static const char mqtt_ca_cert[] =
{
   0x00, 0x00, 0x00, 0x01, 0x73, 0x65, 0x72, 0x76,
   0x65, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
   0x30, 0x82, 0x04, 0x9A, 0x30, 0x82, 0x04, 0x03,
   0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x09, 0x00,
   0xAA, 0x6C, 0xD2, 0x22, 0x21, 0xC0, 0xBC, 0xEB,
   0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
   0xF7, 0x0D, 0x01, 0x01, 0x0D, 0x05, 0x00, 0x30,
   0x67, 0x31, 0x1B, 0x30, 0x19, 0x06, 0x03, 0x55,
   0x04, 0x03, 0x0C, 0x12, 0x41, 0x6C, 0x69, 0x79,
   0x75, 0x6E, 0x20, 0x4D, 0x51, 0x54, 0x54, 0x20,
   0x62, 0x72, 0x6F, 0x6B, 0x65, 0x72, 0x31, 0x13,
   0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C,
   0x0A, 0x61, 0x6C, 0x69, 0x79, 0x75, 0x6E, 0x2E,
   0x63, 0x6F, 0x6D, 0x31, 0x14, 0x30, 0x12, 0x06,
   0x03, 0x55, 0x04, 0x0B, 0x0C, 0x0B, 0x67, 0x65,
   0x6E, 0x65, 0x72, 0x61, 0x74, 0x65, 0x2D, 0x43,
   0x41, 0x31, 0x1D, 0x30, 0x1B, 0x06, 0x09, 0x2A,
   0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x01,
   0x16, 0x0E, 0x69, 0x6F, 0x74, 0x40, 0x61, 0x6C,
   0x69, 0x79, 0x75, 0x6E, 0x2E, 0x63, 0x6F, 0x6D,
   0x30, 0x1E, 0x17, 0x0D, 0x31, 0x36, 0x30, 0x34,
   0x31, 0x35, 0x30, 0x32, 0x30, 0x35, 0x34, 0x33,
   0x5A, 0x17, 0x0D, 0x32, 0x36, 0x30, 0x34, 0x31,
   0x33, 0x30, 0x32, 0x30, 0x35, 0x34, 0x33, 0x5A,
   0x30, 0x5B, 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03,
   0x55, 0x04, 0x03, 0x0C, 0x06, 0x73, 0x65, 0x72,
   0x76, 0x65, 0x72, 0x31, 0x13, 0x30, 0x11, 0x06,
   0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0A, 0x61, 0x6C,
   0x69, 0x79, 0x75, 0x6E, 0x2E, 0x63, 0x6F, 0x6D,
   0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04,
   0x0B, 0x0C, 0x0B, 0x67, 0x65, 0x6E, 0x65, 0x72,
   0x61, 0x74, 0x65, 0x2D, 0x43, 0x41, 0x31, 0x1D,
   0x30, 0x1B, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
   0xF7, 0x0D, 0x01, 0x09, 0x01, 0x16, 0x0E, 0x69,
   0x6F, 0x74, 0x40, 0x61, 0x6C, 0x69, 0x79, 0x75,
   0x6E, 0x2E, 0x63, 0x6F, 0x6D, 0x30, 0x81, 0x9F,
   0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
   0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03,
   0x81, 0x8D, 0x00, 0x30, 0x81, 0x89, 0x02, 0x81,
   0x81, 0x00, 0xAE, 0x4C, 0xFF, 0x87, 0x94, 0xF4,
   0xB0, 0xFE, 0x22, 0x9C, 0xD0, 0x4C, 0x5C, 0x07,
   0x48, 0xD5, 0x0F, 0x3C, 0xC3, 0x70, 0xB4, 0x3C,
   0x60, 0xDD, 0x93, 0x9D, 0x1A, 0xCC, 0xC9, 0x15,
   0xD0, 0x38, 0xBE, 0x0A, 0xD5, 0x9B, 0xF8, 0x67,
   0xFD, 0x37, 0x07, 0x7D, 0xD2, 0x8A, 0x44, 0x3C,
   0x94, 0xCF, 0x02, 0x5B, 0xD4, 0x56, 0xCD, 0x62,
   0x97, 0x4D, 0x95, 0x72, 0xB9, 0x97, 0xFA, 0x8B,
   0x2A, 0x46, 0x3E, 0x5A, 0x9C, 0xC4, 0xCC, 0x91,
   0x63, 0x50, 0xC5, 0x7D, 0x3B, 0x8D, 0x1C, 0x6C,
   0xC5, 0xCF, 0xC9, 0x0D, 0x55, 0x8D, 0xB2, 0xE5,
   0x4A, 0xF9, 0x42, 0x1A, 0x49, 0x95, 0x4E, 0xFF,
   0x10, 0xD4, 0x1F, 0x5F, 0x8A, 0xDC, 0xDB, 0x29,
   0x81, 0x83, 0xCE, 0x72, 0x81, 0x60, 0x44, 0xB9,
   0x3F, 0xC2, 0x1A, 0x76, 0xF1, 0xE6, 0x9B, 0xBE,
   0x03, 0xB4, 0x3F, 0x6E, 0x42, 0x4B, 0x3A, 0x8B,
   0xAD, 0x87, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3,
   0x82, 0x02, 0x58, 0x30, 0x82, 0x02, 0x54, 0x30,
   0x0C, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x01, 0x01,
   0xFF, 0x04, 0x02, 0x30, 0x00, 0x30, 0x11, 0x06,
   0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xF8, 0x42,
   0x01, 0x01, 0x04, 0x04, 0x03, 0x02, 0x06, 0x40,
   0x30, 0x0B, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x04,
   0x04, 0x03, 0x02, 0x05, 0xE0, 0x30, 0x2C, 0x06,
   0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xF8, 0x42,
   0x01, 0x0D, 0x04, 0x1F, 0x16, 0x1D, 0x41, 0x6C,
   0x69, 0x79, 0x75, 0x6E, 0x20, 0x49, 0x6F, 0x54,
   0x20, 0x42, 0x72, 0x6F, 0x6B, 0x65, 0x72, 0x20,
   0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
   0x61, 0x74, 0x65, 0x30, 0x1D, 0x06, 0x03, 0x55,
   0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x1C, 0x39,
   0x73, 0x18, 0x2D, 0xC7, 0xB1, 0x55, 0x14, 0x3A,
   0x31, 0x02, 0x85, 0xF6, 0x0C, 0x47, 0x62, 0xCB,
   0x52, 0x4C, 0x30, 0x81, 0x99, 0x06, 0x03, 0x55,
   0x1D, 0x23, 0x04, 0x81, 0x91, 0x30, 0x81, 0x8E,
   0x80, 0x14, 0x0E, 0xA9, 0x73, 0x43, 0x29, 0xD3,
   0xB5, 0x3D, 0x0E, 0x31, 0x3F, 0xFB, 0x53, 0xC2,
   0x74, 0x7F, 0x81, 0x06, 0xEE, 0x0E, 0xA1, 0x6B,
   0xA4, 0x69, 0x30, 0x67, 0x31, 0x1B, 0x30, 0x19,
   0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x12, 0x41,
   0x6C, 0x69, 0x79, 0x75, 0x6E, 0x20, 0x4D, 0x51,
   0x54, 0x54, 0x20, 0x62, 0x72, 0x6F, 0x6B, 0x65,
   0x72, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55,
   0x04, 0x0A, 0x0C, 0x0A, 0x61, 0x6C, 0x69, 0x79,
   0x75, 0x6E, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x14,
   0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x0C,
   0x0B, 0x67, 0x65, 0x6E, 0x65, 0x72, 0x61, 0x74,
   0x65, 0x2D, 0x43, 0x41, 0x31, 0x1D, 0x30, 0x1B,
   0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D,
   0x01, 0x09, 0x01, 0x16, 0x0E, 0x69, 0x6F, 0x74,
   0x40, 0x61, 0x6C, 0x69, 0x79, 0x75, 0x6E, 0x2E,
   0x63, 0x6F, 0x6D, 0x82, 0x09, 0x00, 0xA9, 0x2B,
   0x32, 0xD7, 0x33, 0xB4, 0xB3, 0xBD, 0x30, 0x81,
   0xB2, 0x06, 0x03, 0x55, 0x1D, 0x11, 0x04, 0x81,
   0xAA, 0x30, 0x81, 0xA7, 0x87, 0x10, 0xFE, 0x80,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x15,
   0xC2, 0xFF, 0xFE, 0xD7, 0x61, 0xA8, 0x87, 0x04,
   0x1E, 0x09, 0xB0, 0x85, 0x87, 0x10, 0x20, 0x02,
   0x1E, 0x09, 0xB0, 0x14, 0x00, 0x0D, 0x3E, 0x15,
   0xC2, 0xFF, 0xFE, 0xD7, 0x61, 0xA8, 0x87, 0x10,
   0x20, 0x02, 0x1E, 0x09, 0xB0, 0x14, 0x00, 0x0D,
   0x54, 0xE5, 0x83, 0x36, 0x82, 0xA0, 0xD3, 0x55,
   0x87, 0x10, 0xFE, 0xC0, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x0D, 0x3E, 0x15, 0xC2, 0xFF, 0xFE, 0xD7,
   0x61, 0xA8, 0x87, 0x10, 0xFE, 0xC0, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x0D, 0xC9, 0xA4, 0xFF, 0x4F,
   0x74, 0xCB, 0x73, 0x25, 0x87, 0x10, 0xFE, 0x80,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x9C,
   0xD1, 0xFF, 0xFE, 0xF2, 0xD5, 0xFA, 0x87, 0x04,
   0xC0, 0xA8, 0x63, 0x01, 0x87, 0x04, 0x0A, 0xD3,
   0x37, 0x02, 0x87, 0x04, 0x0A, 0x25, 0x81, 0x02,
   0x87, 0x04, 0x7F, 0x00, 0x00, 0x01, 0x87, 0x10,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
   0x82, 0x09, 0x6C, 0x6F, 0x63, 0x61, 0x6C, 0x68,
   0x6F, 0x73, 0x74, 0x30, 0x81, 0x85, 0x06, 0x03,
   0x55, 0x1D, 0x20, 0x04, 0x7E, 0x30, 0x7C, 0x30,
   0x7A, 0x06, 0x03, 0x2B, 0x05, 0x08, 0x30, 0x73,
   0x30, 0x1C, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05,
   0x05, 0x07, 0x02, 0x01, 0x16, 0x10, 0x68, 0x74,
   0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x6C, 0x6F, 0x63,
   0x61, 0x6C, 0x68, 0x6F, 0x73, 0x74, 0x30, 0x53,
   0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07,
   0x02, 0x02, 0x30, 0x47, 0x30, 0x10, 0x16, 0x09,
   0x4F, 0x77, 0x6E, 0x54, 0x72, 0x61, 0x63, 0x6B,
   0x73, 0x30, 0x03, 0x02, 0x01, 0x01, 0x1A, 0x33,
   0x54, 0x68, 0x69, 0x73, 0x20, 0x43, 0x41, 0x20,
   0x69, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x41,
   0x6C, 0x69, 0x79, 0x75, 0x6E, 0x20, 0x4D, 0x51,
   0x54, 0x54, 0x20, 0x62, 0x72, 0x6F, 0x6B, 0x65,
   0x72, 0x20, 0x69, 0x6E, 0x73, 0x74, 0x61, 0x6C,
   0x6C, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x6F,
   0x6E, 0x6C, 0x79, 0x30, 0x0D, 0x06, 0x09, 0x2A,
   0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x0D,
   0x05, 0x00, 0x03, 0x81, 0x81, 0x00, 0x97, 0x55,
   0x05, 0xF1, 0x58, 0x13, 0x3F, 0xFA, 0x6F, 0x31,
   0xEB, 0x02, 0xBF, 0xFA, 0x6F, 0x29, 0x8E, 0xEE,
   0x2C, 0x00, 0xE6, 0xAC, 0x94, 0x0D, 0xDF, 0x16,
   0x42, 0x8D, 0x46, 0xDC, 0x3E, 0xD0, 0x92, 0x53,
   0x7C, 0xDC, 0x0F, 0xB9, 0x18, 0xC5, 0x4A, 0xE0,
   0x4F, 0x1B, 0x2F, 0xC8, 0xED, 0x09, 0xB1, 0x6F,
   0x5C, 0xED, 0x2E, 0xEA, 0x12, 0xCD, 0xE2, 0xCC,
   0x34, 0xA0, 0x4D, 0x0D, 0xB6, 0x6D, 0x8C, 0xF3,
   0x2F, 0xBB, 0xF8, 0x66, 0x8E, 0xE8, 0x10, 0x0E,
   0xA2, 0xD6, 0xF6, 0x9F, 0x07, 0x9C, 0x31, 0x2E,
   0xBB, 0x2E, 0xD9, 0xFD, 0xF2, 0x3E, 0xAB, 0x17,
   0x75, 0x8B, 0x2B, 0x6A, 0x29, 0x3B, 0xA2, 0x6B,
   0x1B, 0x90, 0x1E, 0x4A, 0x3F, 0x3A, 0x82, 0xD0,
   0x21, 0xAF, 0x66, 0x55, 0x75, 0xF1, 0xA9, 0xBD,
   0x68, 0xFB, 0xE3, 0xE8, 0x0A, 0xE2, 0x71, 0xBB,
   0x70, 0x79, 0xDA, 0x89, 0x93, 0x9F
};

#define SSL_IOT_INBUF_SIZE           8*1024
#define SSL_IOT_OUTBUF_SIZE          8*1024

int aliyun_iot_network_ssl_connect(TLSDataParams *pTlsData, const char *addr, const char *port, const char *ca_crt, size_t ca_crt_len)
{
	int rc = 0;

	struct sockaddr_in address;
	memset(&address, 0x0, sizeof(struct sockaddr_in));

	pTlsData->socketId = qcom_socket( AF_INET, SOCK_STREAM, 0);
	if(pTlsData->socketId < 0)
	{
		WRITE_IOT_ERROR_LOG("create socket error,fd = %d", pTlsData->socketId);
		rc = ERROR_NET_SOCKET;
		return rc;
	}

	address.sin_addr.s_addr = htonl(iot_inet_addr((char*)addr));
	address.sin_port = htons(atoi(port));
	address.sin_family = AF_INET;

	rc = qcom_connect( pTlsData->socketId, (struct sockaddr *) &address, sizeof (struct sockaddr_in));
	if(rc < 0)
	{
		WRITE_IOT_ERROR_LOG(" socket connect error,fd = %d, rc = %d", pTlsData->socketId, rc);
		qcom_socket_close( pTlsData->socketId );
		pTlsData->socketId = -1;
		rc = ERROR_NET_CONNECT;
		return rc;
	}

	pTlsData->ssl_ctx = qcom_SSL_ctx_new(SSL_CLIENT, SSL_IOT_INBUF_SIZE, SSL_IOT_OUTBUF_SIZE, 0);
	if (NULL == pTlsData->ssl_ctx) 
	{
		WRITE_IOT_ERROR_LOG("SSL ctx new error\n");
		rc = FAIL_RETURN;
		goto EXIT;
	}

	rc = qcom_SSL_setCaList(pTlsData->ssl_ctx, (unsigned char*)mqtt_ca_cert, sizeof(mqtt_ca_cert));
	if (rc < 0)
	{
		WRITE_IOT_ERROR_LOG("ERROR: Unable to set ca list\n");
		goto EXIT;
	}
	
	pTlsData->ssl = qcom_SSL_new(pTlsData->ssl_ctx);
	if (NULL == pTlsData->ssl) 
	{
		WRITE_IOT_ERROR_LOG("SSL new error\n");
		rc = FAIL_RETURN;
		goto EXIT;
	}

	rc = qcom_SSL_set_fd(pTlsData->ssl, pTlsData->socketId);
    if (rc < 0)
    {
        WRITE_IOT_ERROR_LOG("ERROR: Unable to add socket handle to SSL (%d)\n", rc);
		goto EXIT;
    }

	pTlsData->ssl_cfg = aliyun_iot_memory_malloc(sizeof(SSL_CONFIG));
	if(NULL == pTlsData->ssl_cfg)
	{
		WRITE_IOT_ERROR_LOG("malloc SSL_CONFIG failed");
		rc = FAIL_RETURN;
		goto EXIT;
	}
	memset(pTlsData->ssl_cfg, 0, sizeof(SSL_CONFIG));

	pTlsData->ssl_cfg->protocol = SSL_PROTOCOL_TLS_1_2;
	
	/** True to verify certificate time validity */
	pTlsData->ssl_cfg->verify.timeValidity = 1;

    /** True to immediately send a fatal alert on detection of untrusted certificate */
	pTlsData->ssl_cfg->verify.sendAlert = 1;
	
	pTlsData->ssl_cfg->verify.domain = 0;
    pTlsData->ssl_cfg->matchName[0] = '\0';

	pTlsData->ssl_cfg->cipher[0] = TLS_RSA_WITH_AES_256_CBC_SHA256;
	pTlsData->ssl_cfg->cipher[1] = TLS_RSA_WITH_AES_256_CCM;
	pTlsData->ssl_cfg->cipher[2] = TLS_RSA_WITH_AES_128_CBC_SHA256;
	pTlsData->ssl_cfg->cipher[3] = TLS_RSA_WITH_AES_256_CBC_SHA;
	pTlsData->ssl_cfg->cipher[4] = TLS_RSA_WITH_AES_128_CBC_SHA256;
	pTlsData->ssl_cfg->cipher[5] = TLS_RSA_WITH_AES_256_GCM_SHA384;

	rc = qcom_SSL_configure(pTlsData->ssl, pTlsData->ssl_cfg);
	if (rc < 0)
	{
		WRITE_IOT_ERROR_LOG("ERROR: SSL configure failed (%d)\n", rc);
		goto EXIT;
	}

	rc = qcom_SSL_connect(pTlsData->ssl);
	if (rc < 0)
	{
		if (rc == ESSL_TRUST_CertCnTime)
		{
			/** The peer's SSL certificate is trusted, CN matches the host name, time is valid */
			WRITE_IOT_ERROR_LOG("The certificate is trusted\n");
			return 0;
		}
		else if (rc == ESSL_TRUST_CertCn)
		{
	        //调用协议层注册的证书验证钩子函数
	        if(g_certificateVerifyHandler != NULL)
	        {
	            g_certificateVerifyHandler(CERTIFICATE_EXPIRED);
	        }

			/** The peer's SSL certificate is trusted, CN matches the host name, time is expired */
			WRITE_IOT_ERROR_LOG("ERROR: The certificate is expired\n");
			goto EXIT;
		}
		else if (rc == ESSL_TRUST_CertTime)
		{
			/** The peer's SSL certificate is trusted, CN does NOT match the host name, time is valid */
			WRITE_IOT_ERROR_LOG("ERROR: The certificate is trusted, but the host name is not valid\n");
			goto EXIT;
		}
		else if (rc == ESSL_TRUST_Cert)
		{
			/** The peer's SSL certificate is trusted, CN does NOT match host name, time is expired */
			WRITE_IOT_ERROR_LOG("ERROR: The certificate is expired and the host name is not valid\n");
			goto EXIT;
		}
		else if (rc == ESSL_TRUST_None)
		{
			/** The peer's SSL certificate is NOT trusted */
			WRITE_IOT_ERROR_LOG("ERROR: The certificate is NOT trusted\n");
			goto EXIT;
		}
		else
		{
			WRITE_IOT_ERROR_LOG("ERROR: SSL connect failed (%d)\n", rc);
			goto EXIT;
		}
	}

EXIT:
	aliyun_iot_network_ssl_disconnect(pTlsData);
	return (rc == 0) ? 0: -1;
}


